#include "q3la.h"

resultdata_total::resultdata_total()
{

}

resultdata_total::~resultdata_total()
{

}

int resultdata_total::add_results(resultdata *result)
{
	player_t* temp_player;
	for (int i = 0; i < result->get_player_count(); i++) {
		temp_player = get_player (result->get_player(i)->name);
		for (int j = 0; j < MAX_WEAPONS; j++) {
			temp_player->kills[j] += result->get_player(i)->kills[j];
			temp_player->killed[j] += result->get_player(i)->killed[j];
			temp_player->suicides[j] += result->get_player(i)->suicides[j];
		}
		temp_player->deaths += result->get_player(i)->deaths;
		temp_player->playtime += result->get_player(i)->playtime;
		temp_player->mkiol += result->get_player(i)->mkiol;
		temp_player->mkiol_time += result->get_player(i)->mkiol_time;
	}
	return 0;
}

player_t* resultdata_total::get_player(char *name)
{
	player_t* temp_player = &first_player;

	// Check if player exists

	do {
		if (strcmp (temp_player->name, name) == 0) {
			break;
		}
		temp_player = temp_player->next;
	} while (temp_player != 0);

	// if player doesn't exist yet, create 

	if (temp_player == 0) {
		temp_player = add_player (name);
	}

	// Return pointer to existing or newly created player

	return temp_player;
}

player_t* resultdata_total::add_player(char *name)
{
	// Go to last player, add player and return pointer to new player

	player_t* temp_player = &first_player;
	while (temp_player->next != 0) {
		temp_player = temp_player->next;
	}
	temp_player->build_next();
	temp_player = temp_player->next;
	strcpy (temp_player->name, name);
	return temp_player;
}

player_t* resultdata_total::get_player_first()
{
	return &first_player;
}

int resultdata_total::sort_players(sort_t order) // BAD SORTING TECHNIQUE, REWRITE!!!
{
	printf ("\n- Sorting all players        ");
	for (int i = 0; i < get_player_count()-1; i++) {
		printf ("\b\b\b\b\b\b\b(%3i %%)", (100*(i+1))/(get_player_count()-1)); // progress indication
		for (int j = 0; j < get_player_count()-1; j++) {
			player_t* previous = get_player(j-1);
			player_t* player = get_player(j);
			double val1 = 0;
			double val2 = 0;

			switch (order) { // get compare values
			case so_name:
				break;
			case so_skill:
				val1 = (double) player->get_skill();
				val2 = (double) player->next->get_skill();
				break;
			case so_kills:
				val1 = (double) player->get_kills();
				val2 = (double) player->next->get_kills();
				break;
			case so_frags:
				val1 = (double) player->get_kills() - player->deaths - player->get_suicides();
				val2 = (double) player->next->get_kills() - player->next->deaths - player->next->get_suicides();
				break;
			default:
				error::msg_and_exit ("resultdata_total::sort_players - invalid case");
				break;
			}

			switch (order) { // sort if necessary
			case so_name:
				break;
			case so_skill:
			case so_kills:
			case so_frags:
				if (val1 < val2) {
					player_t* next = player->next;
					player_t* next_next = next->next;
					previous->next = next;
					next->next = player;
					player->next = next_next;
				}
				break;
			default:
				error::msg_and_exit ("resultdata_total::sort_players - invalid case");
				break;
			}
		}
	}
	return 0;
}

int resultdata_total::get_player_count()
{
	int count = 0;
	player_t* temp_player = get_player_first();
	while (temp_player->next != 0) {
		count++;
		temp_player = temp_player->next;
	}
	return count;
}

player_t* resultdata_total::get_player(int num)
{
	if (num == -1) {
		return get_player_first();
	}
	player_t* temp_player = get_player_first()->next;
	for (int i = 0; i < num; i++) {
		if (temp_player->next == 0) {
			error::msg_and_exit ("resultdata_total::get_player");
		}
		temp_player = temp_player->next;
	}
	return temp_player;

}

void resultdata_total::dump_players() // DEBUG
{
	int count = 0;
	printf ("\n");
	player_t* temp_player = get_player_first()->next;
	while (temp_player != 0) {
		printf ("\n%3i: %s", ++count, temp_player->name);
		temp_player = temp_player->next;
	}
}
